<?php

function safeRequest($url){

    $ch = curl_init();

    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);

    if(curl_errno($ch)){
        curl_close($ch);
        return false;
    }

    curl_close($ch);
    return $response;
}

function handleAPI($chat_id,$text){

    $text = trim($text);

    // حدیث
    if($text === "حدیث"){
        $response = safeRequest("https://api.keybit.ir/hadis");
        if($response){
            $data = json_decode($response,true);
            if(isset($data["result"]["text"])){
                sendMessage($chat_id,$data["result"]["text"]);
                return true;
            }
        }
        sendMessage($chat_id,"خطا در دریافت حدیث");
        return true;
    }

    // جوک
    if($text === "جوک"){
        $response = safeRequest("https://api.codebazan.ir/jok/");
        if($response){
            sendMessage($chat_id,$response);
            return true;
        }
        sendMessage($chat_id,"خطا در دریافت جوک");
        return true;
    }

    // هوش مصنوعی
    if(str_starts_with($text,"هوش مصنوعی ")){

        $question = str_replace("هوش مصنوعی ","",$text);

        // فعلاً پاسخ تستی (مرحله بعد وصل می‌کنیم به API واقعی)
        sendMessage($chat_id,"سوال شما: ".$question);

        return true;
    }

    return false;
}